LIBRARY ieee;
LIBRARY altera;
USE ieee.std_logic_1164.all;
USE altera.maxplus2.all;

ENTITY adder16 IS
        PORT (a, b  : IN STD_LOGIC_VECTOR(15 DOWNTO 0):="0000000000000000";
              ci    : IN STD_LOGIC := '0';    
              sum   : OUT STD_LOGIC_VECTOR(15 DOWNTO 0);
              co    : OUT STD_LOGIC    
             );
END adder16;  


ARCHITECTURE structure OF adder16 IS
signal low_co: STD_LOGIC;
for all : a_8fadd use entity altera.a_8fadd(behavior);


-- COMPONENT a_8fadd 
  --   PORT (A8, A7, A6, A5, A4, A3, A2, A1 : IN std_logic;
    --       B8, B7, B6, B5, B4, B3, B2, B1 : IN std_logic;
      --     CIN : IN std_logic;
        --   SUM8, SUM7, SUM6, SUM5, SUM4, SUM3, SUM2, SUM1:OUT std_logic;
          -- COUT : OUT std_logic
--           );
-- END COMPONENT;


BEGIN
    U1: a_8fadd
        PORT MAP (
            A8=>a(7),A7=>a(6),A6=>a(5),A5=>a(4),
            A4=>a(3),A3=>a(2),A2=>a(1),A1=>a(0),
            B8=>b(7),B7=>b(6),B6=>b(5),B5=>b(4),
            B4=>b(3),B3=>b(2),B2=>b(1),B1=>b(0),
            CIN => ci,
            SUM8=>sum(7),SUM7=>sum(6),SUM6=>sum(5),SUM5=>sum(4),
            SUM4=>sum(3),SUM3=>sum(2),SUM2=>sum(1),SUM1=>sum(0),
            COUT => low_co
            );
 
 
    U2: a_8fadd
        PORT MAP (
            A8=>a(15),A7=>a(14),A6=>a(13),A5=>a(12),
            A4=>a(11),A3=>a(10),A2=>a(9),A1=>a(8),
            B8=>b(15),B7=>b(14),B6=>b(13),B5=>b(12),
            B4=>b(11),B3=>b(10),B2=>b(9),B1=>b(8),
            CIN => low_co,
            SUM8=>sum(15),SUM7=>sum(14),SUM6=>sum(13),SUM5=>sum(12),
            SUM4=>sum(11),SUM3=>sum(10),SUM2=>sum(9),SUM1=>sum(8),
            COUT=>co
            );
END structure;

